close all; 
clear all;

global lambda_1 lambda_2 sigma phi z_1

pause on

%=====================================================================================
% Agent 1 has CARA utility 
% Agent 2 has CRRA utility

phi       = 0.1;             % Parameter in CARA utility
sigma_vec = [0.3 0.4 0.5];   % Paremeter in CRRA utility

lambda_1 = 1.5;  % Pareto weight for Agent 1
lambda_2 = 1.0;  % Pareto weight for Agent 2

% First we plot the risk tolerance and absolute prudence for the aggregate
% utility function (representative agent) over a certain range.

M = 201; 
z = linspace(0.5, 10.5, M);

T_hat = zeros(3,M);  % Risk tolerance
P_hat = zeros(3,M);  % Absolute prudence
kappa = zeros(2,M);  % Sharing rules

for j = 1:3 
    
    sigma = sigma_vec(j);
    
    for i = 1:M
        
        z_1 = z(i);
        
        [sol_1, val_1, flag_1] = fsolve('SR', 0, optimoptions('fsolve','Display','off'));
        
        %=================================================================================
        
        if ( flag_1 ~= 1 )
            
            fprintf('Error: fsolve is not converging.')
            z(i)
            pause
            
        end
        
        %=================================================================================
        
        kap_1 = sol_1;
        
        kap_2 = ((lambda_2/lambda_1)^(1/sigma))*exp(phi*kap_1/sigma);
        
        kappa(:,i) = [kap_1 kap_2];
             
    end
    
    T_hat(j,:) = 1/phi + kappa(2,:)/sigma;
    
    P_hat(j,:) = ( 1/phi + (1 + sigma)*kappa(2,:)/sigma/sigma )./T_hat(j,:)./T_hat(j,:);
    
end


figure(1)
plot(z, P_hat(1,:));
hold on
plot(z, P_hat(2,:), 'b:');
plot(z, P_hat(3,:), 'g');
title('Absolute Prudence');
